/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class VWLaunchStepProcessorDialog
extends VWModalDialog
implements IVWPropertyChangeSource {
    JApplet m_applet = null;
    Container m_mainContainer = null;
    private VWTrkDataModel m_trackerDataModel = null;
    VWStepNParticipantRenderer m_stepRenderer = new VWStepNParticipantRenderer();
    private VWStepNParticipantRenderer m_participantRenderer = new VWStepNParticipantRenderer();
    private Vector m_activeSteps = null;
    private Object m_selected = null;
    private VWTrkStepOccurrence m_occurrence = null;
    private Vector m_participants = null;
    private Object[] m_selectedParticipants = null;
    private String m_queueName = null;
    private JLabel m_stepLabel = null;
    private JComboBox m_stepCombo = null;
    private DefaultComboBoxModel m_stepModel = null;
    private JLabel m_participantsLabel = null;
    private JList m_participantList = null;
    private DefaultListModel m_participantModel = null;
    private JLabel m_workQueueLabel = null;
    private JLabel m_queueNameUI = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private ItemListener m_stepComboListener = null;
    private ListSelectionListener m_participantListListener = null;
    private ActionListener m_okButtonListener = null;
    private ActionListener m_cancelButtonListener = null;
    private ActionListener m_helpButtonListener = null;
    int m_propertyChangeEventType = 0;
    private VWOpenItem m_vwOpenItem = null;

    public VWLaunchStepProcessorDialog(JApplet applet, Frame parent, Container mainContainer, VWTrkDataModel trackerDataModel) throws Exception {
        super(parent);
        this.m_applet = applet;
        this.m_trackerDataModel = trackerDataModel;
        this.m_mainContainer = mainContainer;
        if (trackerDataModel == null) {
            throw new Exception(VWResource.s_nullTrackerDataModel.toString(VWResource.s_openWorkItemDialogTitle));
        }
        this.initData();
        this.setupLayout();
        this.setupListeners();
        this.updateControls();
        Vector selectedSteps = trackerDataModel.getSelectedSteps();
        if (selectedSteps != null && selectedSteps.size() > 0 && this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < selectedSteps.size(); ++i) {
                Object obj = selectedSteps.elementAt(i);
                if (obj == null || this.m_stepModel.getIndexOf(obj) < 0) continue;
                Object selected = this.m_stepModel.getSelectedItem();
                if (selected == obj) break;
                this.m_stepModel.setSelectedItem(obj);
                break;
            }
        }
    }

    protected void initData() {
        Object selected = null;
        VWTrkStep step = null;
        this.m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        this.m_stepModel = new DefaultComboBoxModel();
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < this.m_activeSteps.size(); ++i) {
                Vector occurrences;
                step = (VWTrkStep)this.m_activeSteps.elementAt(i);
                if (step == null || (occurrences = step.getActiveOccurrences()) == null || occurrences.size() <= 0) continue;
                if (occurrences.size() == 0) {
                    this.m_stepModel.addElement(step);
                    continue;
                }
                for (int j = 0; j < occurrences.size(); ++j) {
                    Object obj = occurrences.elementAt(j);
                    if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                    this.m_stepModel.addElement(obj);
                }
            }
        }
        if (this.m_stepModel.getSize() > 0) {
            selected = this.m_stepModel.getElementAt(0);
        }
        this.initStep(selected);
    }

    private void initStep(Object obj) {
        this.m_selected = obj;
        boolean bInitParticipants = true;
        if (this.m_selected != null) {
            if (this.m_selected instanceof VWTrkStep) {
                Vector occurrences = ((VWTrkStep)this.m_selected).getActiveOccurrences();
                if (occurrences != null && occurrences.size() > 0) {
                    this.m_occurrence = (VWTrkStepOccurrence)occurrences.elementAt(0);
                }
                if (((VWTrkStep)this.m_selected).isComponentStep()) {
                    bInitParticipants = false;
                }
            } else if (this.m_selected instanceof VWTrkStepOccurrence) {
                this.m_occurrence = (VWTrkStepOccurrence)this.m_selected;
                if (((VWTrkStepOccurrence)this.m_selected).getStep().isComponentStep()) {
                    bInitParticipants = false;
                }
            } else {
                this.m_occurrence = null;
            }
        }
        this.initParticipants(bInitParticipants);
    }

    private void initParticipants(boolean bInitParticipants) {
        this.m_participants = this.m_occurrence != null ? this.m_occurrence.getActiveParticipants() : null;
        if (this.m_participantModel == null) {
            this.m_participantModel = new DefaultListModel();
        }
        if (this.m_participantList != null) {
            this.m_participantList.removeSelectionInterval(0, this.m_participantModel.getSize() - 1);
        }
        this.m_participantModel.removeAllElements();
        this.m_queueName = null;
        if (this.m_participants != null && this.m_participants.size() > 0) {
            for (int i = 0; i < this.m_participants.size(); ++i) {
                Object obj = this.m_participants.elementAt(i);
                if (!(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)obj;
                if (this.m_queueName == null) {
                    this.m_queueName = participant.getQueueName();
                }
                if (!bInitParticipants || participant.isLockedByOther()) continue;
                int loc = this.m_participantModel.size();
                VWParticipant vwParticipant = participant.getParticipant();
                for (int j = 0; j < this.m_participantModel.size(); ++j) {
                    VWTrkParticipant p = (VWTrkParticipant)this.m_participantModel.getElementAt(j);
                    VWParticipant tempParticipant = p.getParticipant();
                    if (VWStringUtils.compareIgnoreCase(vwParticipant.getParticipantName(), tempParticipant.getParticipantName()) > 0) continue;
                    loc = j;
                    break;
                }
                if (loc >= this.m_participantModel.size()) {
                    this.m_participantModel.addElement(participant);
                    continue;
                }
                this.m_participantModel.insertElementAt(participant, loc);
            }
        }
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_launchStepProcessorDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 300);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_openWorkItemDialogTitle);
        this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
        this.m_stepCombo = new JComboBox(this.m_stepModel);
        this.m_stepCombo.setRenderer(this.m_stepRenderer);
        this.m_workQueueLabel = new JLabel(VWResource.s_label.toString(VWResource.s_queue));
        this.m_queueNameUI = new JLabel("");
        this.m_participantsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_participants));
        this.m_participantList = new JList(this.m_participantModel);
        this.m_participantList.setSelectionMode(0);
        this.m_participantList.setCellRenderer(this.m_participantRenderer);
        this.m_okButton = new JButton(VWResource.s_open);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(4, 0, 4, 4);
        mainPanel.add((Component)this.m_stepLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_stepCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        mainPanel.add((Component)this.m_workQueueLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_queueNameUI, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 23;
        c.fill = 0;
        c.weightx = 0.0;
        mainPanel.add((Component)this.m_participantsLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)new JScrollPane(this.m_participantList), c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
    }

    private void setupListeners() {
        this.m_stepComboListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VWLaunchStepProcessorDialog.this.performStepSelected();
                }
            }
        };
        this.m_participantListListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                VWLaunchStepProcessorDialog.this.performParticipantSelected();
            }
        };
        this.m_okButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWLaunchStepProcessorDialog.this.m_bCanceled = false;
                try {
                    VWLaunchStepProcessorDialog.this.setVisible(false);
                    if (!VWLaunchStepProcessorDialog.this.performLaunchStepProcessor()) {
                        VWLaunchStepProcessorDialog.this.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    VWLaunchStepProcessorDialog.this.setVisible(true);
                }
            }
        };
        this.m_cancelButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWLaunchStepProcessorDialog.this.m_bCanceled = true;
                VWLaunchStepProcessorDialog.this.setVisible(false);
            }
        };
        this.m_helpButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt036.htm");
            }
        };
        this.m_stepCombo.addItemListener(this.m_stepComboListener);
        this.m_participantList.addListSelectionListener(this.m_participantListListener);
        this.m_okButton.addActionListener(this.m_okButtonListener);
        this.m_cancelButton.addActionListener(this.m_cancelButtonListener);
        this.m_helpButton.addActionListener(this.m_helpButtonListener);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_workQueueLabel.setFont(boldFont);
            this.m_participantsLabel.setFont(boldFont);
        }
    }

    private void updateControls() {
        if (this.m_selected != null) {
            if (this.m_queueName != null) {
                this.m_queueNameUI.setText(this.m_queueName);
            } else {
                this.m_queueNameUI.setText("");
            }
        } else {
            this.m_workQueueLabel.setEnabled(false);
            this.m_queueNameUI.setEnabled(false);
            this.m_participantsLabel.setEnabled(false);
            this.m_participantList.setEnabled(false);
        }
        this.setButtonState();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private void performStepSelected() {
        Object obj = this.m_stepCombo.getSelectedItem();
        if (obj != this.m_selected) {
            this.initStep(obj);
            this.updateControls();
        }
    }

    private void performParticipantSelected() {
        this.m_selectedParticipants = this.m_participantList.getSelectedValues();
        this.updateControls();
    }

    private void setButtonState() {
        boolean bEnable = false;
        int[] selection = this.m_participantList.getSelectedIndices();
        if (selection != null && selection.length == 1) {
            bEnable = true;
        }
        this.m_okButton.setEnabled(bEnable);
    }

    private boolean performLaunchStepProcessor() {
        VWTrkParticipant participant = null;
        boolean bLaunched = false;
        Object[] selectedParticipants = this.m_participantList.getSelectedValues();
        if (selectedParticipants != null && selectedParticipants.length == 1) {
            for (int i = 0; i < selectedParticipants.length; ++i) {
                Cursor currentCursor = null;
                participant = (VWTrkParticipant)selectedParticipants[i];
                try {
                    String[] params = new String[6];
                    VWTrkWorkObject workObject = participant.getParticipantWorkObject();
                    if (workObject != null) {
                        if (participant.isLockedByOther()) {
                            JOptionPane.showMessageDialog(this, VWResource.s_lockedByOther, VWResource.s_openWorkItemDialogTitle, 0);
                            return false;
                        }
                        if (participant.isLockedByCurrentUser()) {
                            if (participant.getIsAltered()) {
                                int result = JOptionPane.showConfirmDialog(this, VWResource.s_saveBeforeUnlock, VWResource.s_openWorkItemDialogTitle, 1, 3);
                                switch (result) {
                                    case 0: {
                                        participant.unlockWork(true, false);
                                        this.notifyPropertyChange(701);
                                        break;
                                    }
                                    case 1: {
                                        participant.unlockWork(false, false);
                                        this.notifyPropertyChange(704);
                                        break;
                                    }
                                    case 2: {
                                        return false;
                                    }
                                }
                            } else {
                                int result = JOptionPane.showConfirmDialog(this, VWResource.s_unlockBeforeOperation, VWResource.s_openWorkItemDialogTitle, 2, 3);
                                switch (result) {
                                    case 0: {
                                        participant.unlockWork(false, false);
                                        this.notifyPropertyChange(701);
                                        break;
                                    }
                                    case 2: {
                                        return false;
                                    }
                                }
                            }
                        }
                        if (this.m_vwOpenItem == null) {
                            this.m_vwOpenItem = new VWOpenItem(VWDefaultSessionProxy.getSession(), this.m_mainContainer, this.m_applet);
                        }
                        VWTrkStep step = null;
                        if (this.m_selected instanceof VWTrkStep) {
                            step = (VWTrkStep)this.m_selected;
                        } else if (this.m_selected instanceof VWTrkStepOccurrence) {
                            step = ((VWTrkStepOccurrence)this.m_selected).getStep();
                        }
                        this.m_vwOpenItem.openStepProcessor(workObject.getCurrentQueueName(), workObject.getWorkObjectNumber(), participant.getStep().getStepName(), step.getStepProcessor());
                        bLaunched = true;
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                if (currentCursor != null) {
                    this.setCursor(currentCursor);
                }
                currentCursor = null;
            }
        }
        return bLaunched;
    }

    public void notifyPropertyChange() {
        if (this.m_participants != null) {
            VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, this.m_propertyChangeEventType));
        }
    }

    public void notifyPropertyChange(int eventType) {
        this.m_propertyChangeEventType = eventType;
        this.notifyPropertyChange();
    }

    public Vector getItemsChanged() {
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        VWTrkStep step = null;
        if (this.m_selected instanceof VWTrkStep) {
            step = (VWTrkStep)this.m_selected;
        } else if (this.m_selected instanceof VWTrkStepOccurrence) {
            step = ((VWTrkStepOccurrence)this.m_selected).getStep();
        }
        if (step != null) {
            steps.addElement(step);
        }
        return steps;
    }

    public boolean isAnyActiveWork() {
        return this.m_activeSteps != null && this.m_activeSteps.size() > 0;
    }
}

